﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        private bool runDcOffsetCal = true;
        // Test Procedures
        public int wlanTest(string standard, string waveformName, int evmAvgCount, int semAvgCount)
        {
            // Configure variables for 801.11 Standard
            string testWaveform = "";
            string testName = "" ;
            testWaveform = waveformName;
            switch (standard)
            {
                case "N20":
                    testName = "802.11N 20 MHz Test";
                    vsag.setupParameters("WLAN_N_20MHZ");
                    dataLog.tstName = "WLAN N20";
                    break;
                case "AC40":
                    testName = "802.11AC 40 MHz Test";
                    vsag.setupParameters("WLAN_AC_40MHZ");
                    dataLog.tstName = "WLAN AC40";
                    break;
                case "N40":
                    testName = "802.11N 40 MHz Test";
                    vsag.setupParameters("WLAN_N_40MHZ");
                    dataLog.tstName = "WLAN N40";
                    break;
                case "AC80":
                    testName = "802.11AC 80 MHz Test";
                    vsag.setupParameters("WLAN_AC_80MHZ");
                    dataLog.tstName = "WLAN AC80";
                    break;
            }

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();


            // One first DUT, run DC Offset calibration at each frequency
            if (runDcOffsetCal)
            {
                vsag.runDcOffsetCal(wlanFreqs, testWaveform);
                runDcOffsetCal = false;
            }
            // Configuration for Dynamic EVM:
            // 1.  Stop RF AWG Playback
            // 2.  Create RF sequence with waveform and off times
            // 3.  Setup ET Pulse Signal
            // 4.  Start ET AWG playback with External Trigger
            // 5.  Start RF AWG on 10 MHz clock edge using Baseband Delay to adjust timing

            double triggerDelay = 0;
            //double pulseTriggerDelay = 800e-9;
            if (useDynamicEvm)
                triggerDelay = dcLeadTime + etArb.arbTrigDelay;

            vsag.stopModulation();
            if (useDynamicEvm)
            {
                // Create the ARB Sequence with Duty cycle
                vsag.generatePulseArbSequence(testWaveform, dcLeadTime + etArb.arbTrigDelay, dutyCycle);
                // Generate Pulse for PA Enable signal
                etArb.playPulseMode(testWaveform, dcLeadTime, dcLagTime, dutyCycle, pulseVoltage, 0);              
                // Setup the VSG and VSA for waveform, band frequency and power level
                vsag.setVsgIqDelay(0);
            }
            else
            {
                // Create the ARB Sequence with Duty cycle
                vsag.generatePulseArbSequence(testWaveform, 0, dutyCycle);
            }
            // Configure for External Trigger on Sequence Wrap signal, delaying by the DC Leadtime
            vsag.configVsaTrigger("EXTERNAL", triggerDelay);

            // Setup the VSG in Sequence Mode
            vsag.setupVsgVsa(testWaveform, wlanFreqs[frequencyIndex], targetPout, targetGain, false, 0, true);

            if (testEvm || testSem)
            {
                vsag.configWlanMeas(standard, wlanFreqs[0], targetPout, evmAvgCount, semAvgCount);
            }

            // Loop over Frequencies
            for (int i = 0; i < wlanFreqs.Length; i++)
            {
                dataLog.addResultsHeader("Frequency = " + (wlanFreqs[i] / 1e6).ToString("0.0") +
                    " MHz, Output Power = " + targetPout.ToString("0.00") + " dBm");

                // Set VSG and VSA to test frequency
                vsag.setTestFreq(wlanFreqs[i]);

                // Servo source until Pout is at correct value
                if (vsag.fftServo)
                    vsag.servoInputPowerFft(targetPout, poutMargin);
                else
                    vsag.servoInputPower(targetPout, poutMargin);

                if (testCurr)
                {
                    // Measure DC Current
                    dcSmu.measCurrent();
                }

                if (testEvm || testSem)
                {
                    // Measure EVM and SEM with X-App
                    // Unlock receiver from driver before starting, lock receiver and update setup when complete
                    vsag.unlockVsa();
                    vsag.setXappFreq(wlanFreqs[i]);
                }

                if (testEvm)
                    vsag.measWlanEvm();
                if (testSem)
                    vsag.measWlanSem(4);


                if (testEvm || testSem)
                {
                    vsag.lockVsa();

                    vsag.configVsaTrigger("EXTERNAL", triggerDelay);
                    vsag.setupVsa(wlanFreqs[i], targetPout);
                }

                // Tests complete, setup for next test
                dataLog.nextTest();
            }

            // Put it back to immediate trigger
            vsag.configVsaTrigger("IMMEDIATE");

            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}